<?php
require_once 'wp_functions.php';

header('Content-Type: text/event-stream');
header('Cache-Control: no-cache');
header('Connection: keep-alive');

function sendUpdate($data) {
    echo json_encode($data) . "\n";
    flush();
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    try {
        // Get form data
        $siteUrl = $_POST['site_url'] ?? '';
        $username = $_POST['username'] ?? '';
        $password = $_POST['password'] ?? '';
        $jsonData = $_POST['jsonData'] ?? '';

        if (empty($siteUrl) || empty($username) || empty($password) || empty($jsonData)) {
            throw new Exception("Tüm alanların doldurulması zorunludur");
        }

        // Decode JSON data
        $articles = json_decode($jsonData, true);
        if ($articles === null) {
            throw new Exception("Geçersiz JSON formatı: " . json_last_error_msg());
        }

        if (!is_array($articles)) {
            throw new Exception("JSON verisi bir dizi içinde olmalıdır");
        }

        foreach ($articles as $index => $article) {
            try {
                $imageId = null;
                
                // Upload image if exists
                if (!empty($article['main_image'])) {
                    $imageId = uploadImageToWordPress($article['main_image'], $siteUrl, $username, $password);
                }
                
                // Create post
                $postResult = createWordPressPost($article, $imageId, $siteUrl, $username, $password);
                
                // Send update
                sendUpdate(array(
                    'type' => 'progress',
                    'current' => $index + 1,
                    'total' => count($articles),
                    'status' => 'success',
                    'title' => $article['title'],
                    'post_id' => $postResult['id'],
                    'image_id' => $imageId
                ));
            } catch (Exception $e) {
                sendUpdate(array(
                    'type' => 'error',
                    'message' => $e->getMessage(),
                    'title' => $article['title'] ?? 'Unknown'
                ));
            }
        }

        sendUpdate(array(
            'type' => 'complete',
            'message' => 'Tüm gönderiler işlendi'
        ));

    } catch (Exception $e) {
        sendUpdate(array(
            'type' => 'error',
            'message' => $e->getMessage()
        ));
    }
}
