<?php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

function uploadImageToWordPress($imageUrl, $siteUrl, $authUser, $authPass) {
    // Get the image data using CURL
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $imageUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $imageData = curl_exec($ch);
    
    if ($imageData === false) {
        throw new Exception("Could not download image from URL: " . $imageUrl . " - " . curl_error($ch));
    }
    
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode !== 200) {
        throw new Exception("Failed to download image. HTTP Code: " . $httpCode);
    }

    // Get image mime type
    $finfo = new finfo(FILEINFO_MIME_TYPE);
    $mimeType = $finfo->buffer($imageData);

    // Get image filename
    $filename = basename($imageUrl);

    // Upload image via WordPress REST API
    $uploadEndpoint = rtrim($siteUrl, '/') . '/wp-json/wp/v2/media';
    
    $headers = array(
        'Content-Type: ' . $mimeType,
        'Content-Disposition: attachment; filename="' . $filename . '"',
        'Authorization: Basic ' . base64_encode($authUser . ':' . $authPass)
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $uploadEndpoint);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $imageData);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode !== 201) {
        throw new Exception("Failed to upload image. HTTP Code: " . $httpCode . ", Response: " . $response);
    }

    $responseData = json_decode($response, true);
    return $responseData['id'];
}

function getExistingTag($tagName, $siteUrl, $authUser, $authPass) {
    $tagEndpoint = rtrim($siteUrl, '/') . '/wp-json/wp/v2/tags';
    $searchEndpoint = $tagEndpoint . '?search=' . urlencode($tagName);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $searchEndpoint);
    curl_setopt($ch, CURLOPT_HTTPGET, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Authorization: Basic ' . base64_encode($authUser . ':' . $authPass)
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    $response = curl_exec($ch);
    curl_close($ch);
    
    $tags = json_decode($response, true);
    
    if (is_array($tags)) {
        foreach ($tags as $tag) {
            if (strtolower($tag['name']) === strtolower($tagName)) {
                return $tag['id'];
            }
        }
    }
    
    return null;
}

function checkExistingPost($title, $siteUrl, $authUser, $authPass) {
    $endpoint = rtrim($siteUrl, '/') . '/wp-json/wp/v2/posts';
    $searchEndpoint = $endpoint . '?search=' . urlencode($title) . '&per_page=1';

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $searchEndpoint);
    curl_setopt($ch, CURLOPT_HTTPGET, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Authorization: Basic ' . base64_encode($authUser . ':' . $authPass)
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode !== 200) {
        throw new Exception("Post arama hatası. HTTP Kodu: " . $httpCode . ", Yanıt: " . $response);
    }
    
    $posts = json_decode($response, true);
    
    if (is_array($posts) && !empty($posts)) {
        foreach ($posts as $post) {
            // Case-insensitive title comparison
            if (strtolower($post['title']['rendered']) === strtolower(html_entity_decode($title))) {
                return $post;
            }
        }
    }
    
    return null;
}

function createWordPressPost($postData, $imageId, $siteUrl, $authUser, $authPass) {
    // Check for existing post first
    $existingPost = checkExistingPost($postData['title'], $siteUrl, $authUser, $authPass);
    if ($existingPost !== null) {
        error_log("[WordPress] Skipping post creation - Post with title '{$postData['title']}' already exists (ID: {$existingPost['id']})");
        return array(
            'status' => 'exists',
            'post' => $existingPost,
            'message' => "Post already exists with ID: {$existingPost['id']}"
        );
    }

    $endpoint = rtrim($siteUrl, '/') . '/wp-json/wp/v2/posts';
    error_log("[WordPress] Creating new post with title: {$postData['title']}");
    
    // Prepare post data
    $data = array(
        'title' => $postData['title'],
        'content' => $postData['content'],
        'status' => 'publish',
        'featured_media' => $imageId,
        'date' => $postData['created_at'] ?? '',
        'meta' => array(
            // Yoast SEO
            '_yoast_wpseo_metadesc' => $postData['meta_description'] ?? '',
            'meta_description' => $postData['meta_description'] ?? '',
            // Rank Math
            'rank_math_description' => $postData['meta_description'] ?? '',
            'rank_math_focus_keyword' => !empty($postData['meta_tags']) ? explode(',', $postData['meta_tags']) : [],
            'rank_math_title' => $postData['title'] ?? '',
            'rank_math_robots' => array(
                'index' => 'index',
                'follow' => 'follow'
            )
        )
    );

    // Add tags if they exist
    if (!empty($postData['meta_tags'])) {
        $tags = explode(',', $postData['meta_tags']);
        $tagIds = array();
        
        foreach ($tags as $tag) {
            $tag = trim($tag);
            if (!empty($tag)) {
                // First check if tag exists
                $existingTagId = getExistingTag($tag, $siteUrl, $authUser, $authPass);
                
                if ($existingTagId !== null) {
                    $tagIds[] = $existingTagId;
                } else {
                    // Create new tag if it doesn't exist
                    $tagEndpoint = rtrim($siteUrl, '/') . '/wp-json/wp/v2/tags';
                    $tagData = array('name' => $tag);
                    
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $tagEndpoint);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($tagData));
                    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                        'Content-Type: application/json',
                        'Authorization: Basic ' . base64_encode($authUser . ':' . $authPass)
                    ));
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                    
                    $response = curl_exec($ch);
                    $responseData = json_decode($response, true);
                    curl_close($ch);
                    
                    if (isset($responseData['id'])) {
                        $tagIds[] = $responseData['id'];
                    }
                }
            }
        }
        
        if (!empty($tagIds)) {
            $data['tags'] = $tagIds;
        }
    }

    // Create post
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $endpoint);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Authorization: Basic ' . base64_encode($authUser . ':' . $authPass)
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode !== 201) {
        throw new Exception("Failed to create post. HTTP Code: " . $httpCode . ", Response: " . $response);
    }

    $responseData = json_decode($response, true);
    return array(
        'status' => 'created',
        'post' => $responseData,
        'message' => "Post created successfully with ID: {$responseData['id']}"
    );
}
