<?php
use Google\Auth\OAuth2;
use GuzzleHttp\Client;

function send_fcm_v1_notification($title, $body, $tokens, $data = []) {
    $serviceAccountPath = __DIR__ . '/adminsdk.json'; // JSON yolunu güncelle
    $projectId = 'herdem-aviation'; // Firebase projenin ID'si

    // FCM endpoint
    $url = "https://fcm.googleapis.com/v1/projects/{$projectId}/messages:send";

    // Scope'lar
    $scopes = [
        'https://www.googleapis.com/auth/firebase.messaging',
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    // JWT oluştur ve Access Token al
    $oauth = new OAuth2([
        'audience' => 'https://oauth2.googleapis.com/token',
        'issuer' => json_decode(file_get_contents($serviceAccountPath))->client_email,
        'signingAlgorithm' => 'RS256',
        'signingKey' => json_decode(file_get_contents($serviceAccountPath))->private_key,
        'scope' => implode(' ', $scopes),
    ]);

    $authToken = $oauth->fetchAuthToken();
    $accessToken = $authToken['access_token'];

    $client = new Client();
    $results = [];

    foreach ($tokens as $token) {
        $payload = [
            'message' => [
                'token' => $token,
                'notification' => [
                    'title' => $title,
                    'body' => $body,
                    'image' => $data['image'] ?? null
                ],
                'data' => [
                    'click_action' => 'FLUTTER_NOTIFICATION_CLICK',
                    'id' => $data['id'] ?? '1',
                    'status' => 'done',
                    'page' => $data['page'] ?? 'home',
                    'url' => $data['url'] ?? '',
                ]
            ]
        ];

        try {
            $response = $client->post($url, [
                'headers' => [
                    'Authorization' => "Bearer {$accessToken}",
                    'Content-Type'  => 'application/json',
                ],
                'json' => $payload
            ]);

            $results[] = [
                'token' => $token,
                'status' => $response->getStatusCode(),
                'response' => json_decode($response->getBody(), true),
            ];
        } catch (\Exception $e) {
            $results[] = [
                'token' => $token,
                'error' => $e->getMessage(),
            ];
        }
    }

    return $results;
}
$tokens = [
    'your_device_token_1',
    'your_device_token_2',
];

$data = [
    'id' => '123',
    'image' => 'https://example.com/banner.png',
    'page' => 'home',
    'url' => 'https://example.com',
];

$result = send_fcm_v1_notification('Merhaba', 'Yeni bir mesajın var!', $tokens, $data);

echo '<pre>';
print_r($result);
echo '</pre>';
