const path = window.location.pathname;
const pathSegments = path.split('/');
const restoranID = pathSegments[pathSegments.length - 1];
const host = 'https://dijitalmenu.firesoftyazilim.com/api/getMenu.php?id=' + restoranID;

let lang = "tr";
let buiznes = {};
let font = "";
const content = document.getElementById('product-list');

const dropdown = document.getElementById('language-selector');

const head = document.getElementById('head');
console.log(host);
fetch(host)
    .then(response => response.json())
    .then(data => {
        buiznes = data;
        font = buiznes.font;
        document.title = buiznes.businessName;

        const name = `
            <center><img src="${buiznes.businessLogo}" style="width: 15%;"></center>
            <br>
            <div  style="background-color: #000 ">
            <h2 class="w3-wide w3-center" style="color: white">${buiznes.businessName} </h2> 
            </div> <br>`;


        const diller = [];
        let tr = {};
        Object.entries(buiznes.Languages).forEach(([key, value]) => {
            diller.push(value);
            if (value.code === "tr") {
                tr = value;
            }
        });
        let secilenElemanIndex = diller.indexOf(tr);
        if (secilenElemanIndex !== -1) {
            diller.splice(secilenElemanIndex, 1);
            diller.unshift(tr);
        }
        diller.forEach(dil => {
            const option = `<option value="${dil.code}">${dil.language}</option><br>`;
            console.log(option);

            dropdown.innerHTML += option;
        });

        
        head.style.backgroundImage = `url(${buiznes.backGroundPhoto || 'assets/not.jpg'})`;
        head.innerHTML += name;


        addElement();

       
        

    }).catch(error => {
        console.log(error);
       // window.location.href = "firesoft.html";
    });



function addElement() {
    const inputElement = document.getElementById('search');
    const inputValue = inputElement.value;

    content.innerHTML = '';
    const kategoriler = [];
    const products = [];

    console.log(buiznes.Categories);
    Object.entries(buiznes.Categories).forEach(([key, value]) => {
        kategoriler.push(value);
    });
    Object.entries(buiznes.Products).forEach(([key, value]) => {
        products.push(value);
    });

    kategoriler.forEach(kategori => {
        const categoryContainer = document.createElement('div');
        categoryContainer.classList.add("w3-container");
        categoryContainer.innerHTML += `<div id="category"><h2 style="text-align: center">${kategori.name[lang]}</h2></div>`;
        
        
        products.forEach(product => {
            const productContainer = document.createElement('div');
        
          if(product.categoryId ==kategori.id){
              if (inputValue.trim() === "") {
                const productHTML = `
              <div class="w3-third">
                <div class="w3-container w3-white">
                  <img src="${product.imageUrl || 'assets/not.png'}" alt="${product.name[lang]}"  class="w3-hover-opacity">
                  <div style="padding: 5px">
                  <p><b>${product.name[lang]}</b></p>
                  <p class="w3-opacity">${product.price[lang]}</p>
                  <p>${product.dest[lang] || '-'}</p>
                  </div>
                </div>
              </div>  `;
              productContainer.innerHTML+= productHTML;
            }else{
               if(product.name[lang].toLowerCase().search(inputValue.trim().toLowerCase()) !== -1){
                const productHTML = `
                <div class="w3-third">
                  <div class="w3-container w3-white">
                    <img src="${product.imageUrl || 'assets/not.png'}" alt="${product.name[lang]}"  class="w3-hover-opacity">
                    <div style="padding: 5px">
                    <p><b>${product.name[lang]}</b></p>
                    <p class="w3-opacity">${product.price[lang]}</p>
                    <p>${product.dest[lang] || '-'}</p>
                    </div>
                  </div>
                </div>  `;
                productContainer.innerHTML+= productHTML;
               }
            }
            categoryContainer.appendChild(productContainer);

          }
        });
        content.appendChild(categoryContainer);
        
    });

       

}

function dropdownChanged(select) {
    lang = select.value;
    addElement();
}